<?php
 
include_once 'conexao.php';
   
class ModeloVenda   
{    
	static public function mdlAddVenda($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO venda	
						(idProduto,preco,precoVenda,tipoProduto,tipoVenda,cumissaoFiliado,cumissaoPlataforma, estadoVenda, idCliente, dataCadastro, idFiliado) VALUES 
						(:idProduto,:preco,:precoVenda,:tipoProduto,:tipoVenda,:cumissaoFiliado,:cumissaoPlataforma, :estadoVenda, :idCliente, :dataCadastro, :idFiliado)");
		$stmt->bindParam(":idProduto", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":preco", $dados["preco"], PDO::PARAM_STR);
		$stmt->bindParam(":precoVenda", $dados["precoVenda"], PDO::PARAM_STR);
		$stmt->bindParam(":tipoProduto", $dados["tipoProduto"], PDO::PARAM_STR);
		$stmt->bindParam(":tipoVenda", $dados["tipoVenda"], PDO::PARAM_STR);
		$stmt->bindParam(":cumissaoFiliado", $dados["cumissaoFiliado"], PDO::PARAM_STR);
		$stmt->bindParam(":cumissaoPlataforma", $dados["cumissaoPlataforma"], PDO::PARAM_STR);
		$stmt->bindParam(":estadoVenda", $dados["estadoVenda"], PDO::PARAM_STR);
		$stmt->bindParam(":idCliente", $dados["idCliente"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idFiliado", $dados["idFiliado"], PDO::PARAM_STR);
		
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}
 
	static public function mdlMostrarVendasPoridVagaEIdCliente($idProduto, $idCliente) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM venda where idProduto = :idProduto and idCliente = :idCliente");
			$stmt->bindParam(":idProduto", $idProduto, PDO::PARAM_STR);
			$stmt->bindParam(":idCliente", $idCliente, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasVendasDoAfiliadoPorIdFiliado($idFiliado) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM venda where idFiliado = :idFiliado");
		$stmt->bindParam(":idFiliado", $idFiliado, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}
  
	static public function mdlMostrarTodasVendasDoAfiliadoPeloIdVagaEPeloIdUsurario($idVaga, $idFiliado) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM venda where idProduto = :idProduto and idFiliado = :idFiliado");
			$stmt->bindParam(":idProduto", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idFiliado", $idFiliado, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 
	static public function mdlMostrarTodasVendasDoProdutoPeloIdVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM venda where idProduto = :idProduto");
			$stmt->bindParam(":idProduto", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasVendasDoUsuarioIdUsurario($idVaga, $idFiliado) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM venda where idFiliado = :idFiliado");
			$stmt->bindParam(":idProduto", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idFiliado", $idFiliado, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarMinhasVagasPorIdUsurario($idRecrutador) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where idRecrutador = :idRecrutador");
			$stmt->bindParam(":idRecrutador", $idRecrutador, PDO::PARAM_STR);
			$stmt ->execute();
			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarVagasPorCategoriaDaVaga($tipoVaga) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where tipoVaga = :tipoVaga");
			$stmt->bindParam(":tipoVaga", $tipoVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasVagas() {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga ");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlEditarPrecoDoCertificadoPorIdVaga($idVaga, $precoCertificado){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET precoCertificado = :precoCertificado where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":precoCertificado", $precoCertificado, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEditarModeloDoCertificadoPorIdVaga($idVaga, $idModeloCertificado){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET idModeloCertificado = :idModeloCertificado where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":idModeloCertificado", $idModeloCertificado, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEliminarLikeDoEventoPorIdLike($id, $idUsuario){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM eventolikes where idEvento = :id and idUsuario = :idUsuario");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>